<?php
// blocker.php (FINAL - BULLETPROOF VERSION)

$block_file_path = 'blocked_ips.txt';

// This function ADDS an IP to the block list
function block_ip_address($ip_to_block, $block_file) {
    // Before we do anything, check if the file exists and is writable.
    if (!file_exists($block_file)) {
        // Try to create the file. If it fails, stop with a clear error.
        if (@fopen($block_file, 'w') === false) {
            die("FATAL ERROR: The block list file ('{$block_file}') does not exist and could not be created. Please create the file manually and set its permissions to be writable (e.g., 666).");
        }
        fclose(fopen($block_file, 'w')); // Close the handle after creating
    }

    if (!is_writable($block_file)) {
        die("FATAL ERROR: The block list file ('{$block_file}') is not writable. Please check the file permissions (e.g., set to 666).");
    }

    if (!is_ip_blocked($ip_to_block, $block_file)) {
        file_put_contents($block_file, $ip_to_block . "\n", FILE_APPEND);
    }
}

// This function CHECKS if an IP is on the block list
function is_ip_blocked($ip_to_check, $block_file) {
    if (file_exists($block_file)) {
        $blocked_ips = file($block_file, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
        return in_array($ip_to_check, $blocked_ips);
    }
    return false;
}